/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.BaseScriptData;
import noppes.npcs.util.Util;

public class PlayerScriptData
extends BaseScriptData {
    private static TreeMap<Long, String> console = new TreeMap();
    private static List<Integer> errored = new ArrayList<Integer>();
    private long lastPlayerUpdate = 0L;
    private final EntityPlayer player;
    private IPlayer<?> playerAPI;

    public PlayerScriptData(EntityPlayer player) {
        this.player = player;
        if (player != null) {
            this.enabled = ScriptController.Instance.playerScripts.enabled;
            this.hadInteract = ScriptController.Instance.playerScripts.hadInteract;
            this.lastInited = ScriptController.Instance.playerScripts.lastInited;
            this.scriptLanguage = ScriptController.Instance.playerScripts.scriptLanguage;
            this.scripts.clear();
            for (ScriptContainer sCon : ScriptController.Instance.playerScripts.scripts) {
                this.scripts.add(sCon.copyTo(this));
            }
        }
    }

    @Override
    public void clear() {
        console = new TreeMap();
        errored = new ArrayList<Integer>();
        this.scripts = new ArrayList();
    }

    @Override
    public void clearConsole() {
        console.clear();
    }

    @Override
    public TreeMap<Long, String> getConsoleText() {
        return console;
    }

    @Override
    public void clearConsoleText(Long key) {
        console.remove(key);
    }

    public IPlayer<?> getPlayer() {
        if (this.playerAPI == null) {
            this.playerAPI = (IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)this.player);
        }
        return this.playerAPI;
    }

    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString mesPlayer;
        Object p = this.player;
        if (event instanceof PlayerEvent && p == null) {
            p = ((PlayerEvent)((Object)event)).player.getMCEntity();
        }
        TextComponentString message = new TextComponentString("");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        if (type != null) {
            TextComponentString hook = new TextComponentString("Hook \"");
            hook.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString hookType = new TextComponentString(type);
            hookType.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString hookEnd = new TextComponentString("\"; ");
            hookEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)hook).func_150257_a((ITextComponent)hookType).func_150257_a((ITextComponent)hookEnd);
        }
        if (p == null) {
            mesPlayer = new TextComponentString("Global players script");
            mesPlayer.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        } else {
            mesPlayer = new TextComponentString("Player: \"");
            mesPlayer.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString name = new TextComponentString(p.func_70005_c_());
            name.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesUUID = new TextComponentString("\"; UUID: \"");
            mesUUID.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString uuid = new TextComponentString(p.func_110124_au().toString());
            uuid.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesEnd = new TextComponentString("\" in ");
            mesEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            mesPlayer = mesPlayer.func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)mesUUID).func_150257_a((ITextComponent)uuid).func_150257_a((ITextComponent)mesEnd);
            int dimID = p.field_70170_p == null ? 0 : p.field_70170_p.field_73011_w.getDimension();
            double x = (double)Math.round(p.field_70165_t * 100.0) / 100.0;
            double y = (double)Math.round(p.field_70163_u * 100.0) / 100.0;
            double z = (double)Math.round(p.field_70161_v * 100.0) / 100.0;
            TextComponentString posClick = new TextComponentString("dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z);
            posClick.func_150256_b().func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/noppes world tp @p " + dimID + " " + x + " " + y + " " + z)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("script.hover.error.pos.tp", new Object[0])));
            mesPlayer = mesPlayer.func_150257_a((ITextComponent)posClick);
        }
        TextComponentString side = new TextComponentString("; Side: " + (this.isClient() ? "Client" : "Server"));
        side.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a((ITextComponent)mesPlayer).func_150257_a((ITextComponent)side);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.scripts = NBTTags.GetScript(compound.func_150295_c("Scripts", 10), this, false);
        this.scriptLanguage = Util.instance.deleteColor(compound.func_74779_i("ScriptLanguage"));
        this.enabled = compound.func_74767_n("ScriptEnabled");
        console = NBTTags.GetLongStringMap(compound.func_150295_c("ScriptConsole", 10));
    }

    @Override
    public void runScript(String type, Event event) {
        super.runScript(type, event);
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited || ScriptController.Instance.lastPlayerUpdate > this.lastPlayerUpdate) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            errored.clear();
            if (this.player != null) {
                this.scripts.clear();
                for (ScriptContainer script : ScriptController.Instance.playerScripts.scripts) {
                    ScriptContainer s = new ScriptContainer(this, this.isClient());
                    s.readFromNBT(script.writeToNBT(new NBTTagCompound()), this.isClient());
                    this.scripts.add(s);
                }
            }
            this.lastPlayerUpdate = ScriptController.Instance.lastPlayerUpdate;
            if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                EventHooks.onPlayerInit(this);
            }
        }
        for (int i = 0; i < this.scripts.size(); ++i) {
            ScriptContainer script;
            script = (ScriptContainer)this.scripts.get(i);
            if (errored.contains(i)) continue;
            script.run(type, event);
            if (script.errored) {
                errored.add(i);
            }
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                if (console.containsKey(entry.getKey())) continue;
                console.put(entry.getKey(), " tab " + (i + 1) + ":\n" + entry.getValue());
            }
            script.console.clear();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Scripts", (NBTBase)NBTTags.NBTScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        compound.func_74782_a("ScriptConsole", (NBTBase)NBTTags.NBTLongStringMap(console));
        return compound;
    }
}

